<!DOCTYPE html>
<html lang="fa">

<head>
    <meta charset="utf-8"/>
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('theme/frontend/assets/img/apple-icon.png')); ?>">
    <link rel="icon" type="image/png" href="<?php echo e(asset('theme/frontend/assets/img/favicon.png')); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no'
          name='viewport'/>
    <title>Topkala</title>
    <!--     Fonts and icons     -->
    <link rel="stylesheet" href="<?php echo e(asset('theme/frontend/fonts/font-awesome/css/font-awesome.min.css')); ?>"/>
    <!-- CSS Files -->
    <link href="<?php echo e(asset('theme/frontend/assets/css/bootstrap.min.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('theme/frontend/assets/css/now-ui-kit.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('theme/frontend/assets/css/plugins/owl.carousel.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('theme/frontend/assets/css/plugins/owl.theme.default.min.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('theme/frontend/assets/css/main.css')); ?>" rel="stylesheet"/>
</head>

<body class="index-page sidebar-collapse">

<!-- responsive-header -->
<nav class="navbar direction-ltr fixed-top header-responsive">
    <div class="container">
        <div class="navbar-translate">
            <a class="navbar-brand" href="#pablo">
                <img src="<?php echo e(asset('theme/frontend/assets/img/logo.png')); ?>" height="24px" alt="">
            </a>
            <button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse"
                    data-target="#navigation" aria-controls="navigation-index" aria-expanded="false"
                    aria-label="Toggle navigation">
                <span class="navbar-toggler-bar bar1"></span>
                <span class="navbar-toggler-bar bar2"></span>
                <span class="navbar-toggler-bar bar3"></span>
            </button>
            <div class="search-nav default">
                <form action="">
                    <input type="text" placeholder="جستجو ...">
                    <button type="submit"><img src="<?php echo e(asset('theme/frontend/assets/img/search.png')); ?>" alt=""></button>
                </form>
                <ul>
                    <li><a href="#"><i class="now-ui-icons users_single-02"></i></a></li>
                    <li><a href="#"><i class="now-ui-icons shopping_basket"></i></a></li>
                </ul>
            </div>
        </div>

        <div class="collapse navbar-collapse justify-content-end" id="navigation">
            <div class="logo-nav-res default text-center">
                <a href="#">
                    <img src="<?php echo e(asset('theme/frontend/assets/img/logo.png')); ?>" height="36px" alt="">
                </a>
            </div>
            <ul class="navbar-nav default">
                <li class="sub-menu">
                    <a href="#">کالای دیجیتال</a>
                    <ul>
                        <li class="sub-menu">
                            <a href="#">لوازم جانبی گوشی</a>
                            <ul>
                                <li>
                                    <a href="#">کیف و کاور گوشی</a>
                                </li>
                                <li>
                                    <a href="#">پاور بانک</a>
                                </li>
                                <li>
                                    <a href="#">هندزفری،هدفون</a>
                                </li>
                                <li>
                                    <a href="#">پایه نگهدارنده گوشی</a>
                                </li>
                            </ul>
                        </li>
                        <li class="sub-menu">
                            <a href="#">گوشی موبایل</a>
                            <ul>
                                <li>
                                    <a href="#"></a>
                                </li>
                                <li>
                                    <a href="#">آیفون اپل</a>
                                </li>
                                <li>
                                    <a href="#">هوآوی</a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">ساعت هوشمند</a>
                        </li>
                        <li>
                            <a href="#">اسپیکر بلوتوث و با سیم</a>
                        </li>
                        <li class="sub-menu">
                            <a href="#">موبایل</a>
                            <ul>
                                <li>
                                    <a href="#">Apple</a>
                                </li>
                                <li>
                                    <a href="#">Asus</a>
                                </li>
                                <li>
                                    <a href="#">HTC</a>
                                </li>
                                <li>
                                    <a href="#">LG</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li class="sub-menu">
                    <a href="#">آرایشی،بهداشت</a>
                    <ul>
                        <li class="sub-menu">
                            <a href="#">لوازم جانبی گوشی</a>
                            <ul>
                                <li>
                                    <a href="#">کیف و کاور گوشی</a>
                                </li>
                                <li>
                                    <a href="#">پاور بانک</a>
                                </li>
                                <li>
                                    <a href="#">هندزفری،هدفون</a>
                                </li>
                                <li>
                                    <a href="#">پایه نگهدارنده گوشی</a>
                                </li>
                            </ul>
                        </li>
                        <li class="sub-menu">
                            <a href="#">گوشی موبایل</a>
                            <ul>
                                <li>
                                    <a href="#"></a>
                                </li>
                                <li>
                                    <a href="#">آیفون اپل</a>
                                </li>
                                <li>
                                    <a href="#">هوآوی</a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">ساعت هوشمند</a>
                        </li>
                        <li>
                            <a href="#">اسپیکر بلوتوث و با سیم</a>
                        </li>
                        <li class="sub-menu">
                            <a href="#">موبایل</a>
                            <ul>
                                <li>
                                    <a href="#">Apple</a>
                                </li>
                                <li>
                                    <a href="#">Asus</a>
                                </li>
                                <li>
                                    <a href="#">HTC</a>
                                </li>
                                <li>
                                    <a href="#">LG</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li class="sub-menu">
                    <a href="#">خودرو،ابزار و اداری</a>
                    <ul>
                        <li class="sub-menu">
                            <a href="#">لوازم جانبی گوشی</a>
                            <ul>
                                <li>
                                    <a href="#">کیف و کاور گوشی</a>
                                </li>
                                <li>
                                    <a href="#">پاور بانک</a>
                                </li>
                                <li>
                                    <a href="#">هندزفری،هدفون</a>
                                </li>
                                <li>
                                    <a href="#">پایه نگهدارنده گوشی</a>
                                </li>
                            </ul>
                        </li>
                        <li class="sub-menu">
                            <a href="#">گوشی موبایل</a>
                            <ul>
                                <li>
                                    <a href="#"></a>
                                </li>
                                <li>
                                    <a href="#">آیفون اپل</a>
                                </li>
                                <li>
                                    <a href="#">هوآوی</a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">ساعت هوشمند</a>
                        </li>
                        <li>
                            <a href="#">اسپیکر بلوتوث و با سیم</a>
                        </li>
                        <li class="sub-menu">
                            <a href="#">موبایل</a>
                            <ul>
                                <li>
                                    <a href="#">Apple</a>
                                </li>
                                <li>
                                    <a href="#">Asus</a>
                                </li>
                                <li>
                                    <a href="#">HTC</a>
                                </li>
                                <li>
                                    <a href="#">LG</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li>
                    <a href="#">مد و پوشاک</a>
                </li>
                <li>
                    <a href="#">خانه و آشپزخانه</a>
                </li>
                <li>
                    <a href="#">کتاب،لوازم تحریر</a>
                </li>
                <li>
                    <a href="#">ورزش و سفر</a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<!-- responsive-header -->

<div class="wrapper default">

    <!-- header -->
    <header class="main-header default">
        <div class="container">
            <div class="row">
                <div class="col-lg-2 col-md-3 col-sm-4 col-5">
                    <div class="logo-area default">
                        <a href="#">
                            <img src="<?php echo e(asset('theme/frontend/assets/img/logo.png')); ?>" alt="">
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 col-md-5 col-sm-8 col-7">
                    <div class="search-area default">
                        <form action="" class="search">
                            <input type="text" id="gsearchsimple"
                                   placeholder="نام کالا، برند و یا دسته مورد نظر خود را جستجو کنید…">
                            <ul class="list-group search-box-list">
                                <li class="list-group-item contsearch">
                                    <a href="#" class="gsearch">
                                        <i class="fa fa-clock-o"></i>
                                        گوشی موبایل
                                    </a>
                                </li>
                                <li class="list-group-item contsearch">
                                    <a href="#" class="gsearch">
                                        <i class="fa fa-clock-o"></i>
                                        لپ تاپ
                                    </a>
                                </li>
                                <li class="list-group-item contsearch">
                                    <a href="#" class="gsearch">
                                        <i class="fa fa-clock-o"></i>
                                        کفش
                                    </a>
                                </li>
                                <li class="list-group-item contsearch">
                                    <a href="#" class="gsearch">
                                        <i class="fa fa-clock-o"></i>
                                        مانتو
                                    </a>
                                </li>
                                <li class="list-group-item contsearch">
                                    <a href="#" class="gsearch">
                                        <i class="fa fa-clock-o"></i>
                                        لباس ورزشی
                                    </a>
                                </li>
                            </ul>
                            <div class="localSearchSimple"></div>
                            <button type="submit"><img src="<?php echo e(asset('theme/frontend/assets/img/search.png')); ?>" alt="">
                            </button>
                        </form>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12">
                    <div class="user-login dropdown">
                        <a href="<?php echo e(route('login')); ?>" class="btn btn-neutral dropdown-toggle" data-toggle="dropdown"
                           id="navbarDropdownMenuLink1">
                            ورود / ثبت نام
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink1">
                            <div class="dropdown-item">
                                <a href="<?php echo e(route('login')); ?>" class="btn btn-info">ورود به تاپ کالا</a>
                            </div>
                            <div class="dropdown-item font-weight-bold">
                                <span>کاربر جدید هستید؟</span> <a class="register" href="#">ثبت‌نام</a>
                            </div>
                            <hr>
                            <div class="dropdown-item">
                                <a href="#" class="dropdown-item-link">
                                    <i class="now-ui-icons users_single-02"></i>
                                    پروفایل
                                </a>
                            </div>
                            <div class="dropdown-item">
                                <a href="#" class="dropdown-item-link">
                                    <i class="now-ui-icons shopping_bag-16"></i>
                                    پیگیری سفارش
                                </a>
                            </div>
                        </ul>
                    </div>
                    <div class="cart dropdown">
                        <a href="#" class="btn dropdown-toggle" data-toggle="dropdown" id="navbarDropdownMenuLink1">
                            <img src="<?php echo e(asset('theme/frontend/assets/img/shopping-cart.png')); ?>" alt="">
                            سبد خرید
                            <span class="count-cart">2</span>
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink1">
                            <div class="basket-header">
                                <div class="basket-total">
                                    <span>مبلغ کل خرید:</span>
                                    <span> ۲۳,۵۰۰</span>
                                    <span> تومان</span>
                                </div>
                                <a href="#" class="basket-link">
                                    <span>مشاهده سبد خرید</span>
                                    <div class="basket-arrow"></div>
                                </a>
                            </div>
                            <ul class="basket-list">
                                <li>
                                    <a href="#" class="basket-item">
                                        <button class="basket-item-remove"></button>
                                        <div class="basket-item-content">
                                            <div class="basket-item-image">
                                                <img alt=""
                                                     src="<?php echo e(asset('theme/frontend/assets/img/cart/2324935.jpg')); ?>">
                                            </div>
                                            <div class="basket-item-details">
                                                <div class="basket-item-title">هندزفری بلوتوث مدل S530
                                                </div>
                                                <div class="basket-item-params">
                                                    <div class="basket-item-props">
                                                        <span> ۱ عدد</span>
                                                        <span>رنگ مشکی</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                            <a href="#" class="basket-submit">ورود و ثبت سفارش</a>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <nav class="main-menu">
            <div class="container">
                <ul class="list float-right">
                    <?php $__currentLoopData = $category_header_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-item list-item-has-children mega-menu mega-menu-col-5">
                            <a class="nav-link" href="<?php echo e(route('categoryLoad',$value->slug)); ?>"><?php echo e($value->name); ?></a>
                            <ul class="sub-menu nav">

                                <ul class="sub-menu nav">
                                    <?php echo e(\App\Http\Controllers\admin\CategoryController::showHeaderMenu($value->id)); ?>

                                </ul>
                            </ul>
                        </li>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-item amazing-item">
                        <a class="nav-link" href="#" target="_blank">شگفت‌انگیزها</a>
                    </li>
                </ul>
            </div>
        </nav>
    </header>
    <div class="overlay-search-box"></div>
    <!-- header -->
<?php /**PATH /Users/mac/Downloads/laravel/digisite/resources/views/frontend/partials/headre.blade.php ENDPATH**/ ?>